define([
		'app',
		'sud_service',
		'event-bus_service',
		'SudController',
		'landing_service',
		'resourcedirectory_service',
		'authentication_service',
		'mhpuser_service',
		'patient',
		'connection_error_service',
		'connection_timeout_service',
		'modalService',
		'SplashController',
		'HeaderController',
		'FooterController',
		'MainController',
		'HelpController',
		'AboutController',
		'accessibleDatePickerServices',
		'DateControls',
		'highcharts-ng',
		'TwoPanelController',
		'SecondaryNavigationController',
		'HomeModule',
		'VarUtilityModule'
	],
	function (app) {
		"use strict";

		app.config(function ($stateProvider, unsavedWarningsConfigProvider) {
            $stateProvider
                .state('main.auth.unauthorized', {
                    url: '/unauthorized',
                    data: {
                        homeName: 'VA Tool Set Home'
                    },
                    params: {
                        moduleName: null,
                        primaryHeaderTitle: null
                    },
                    views: {
                        '@main': {
                            templateUrl: 'src/modules/home/unauthorized/unauthorized_template.html',
                            controller: 'UnauthorizedController'
                        }
                    }
                })
                .state('main', {
                    abstract: true,
                    data: {
                        requiresAuth: true
                    },
                    views: {
                        "": {
                            templateUrl: 'src/container/main/main_template.html',
                            controller: 'MainController'
                        },
                        'header@main': {
                            templateUrl: 'src/container/components/header/header_template.html',
                            controller: 'HeaderController'
                        },
                        'footer@main': {
                            templateUrl: 'src/container/components/footer/footer_template.html',
                            controller: 'FooterController'
                        }
                    },
                    resolve: {
                        authcode: function ($q, $location, authenticationService, pageService, $timeout) {
                            var defer = $q.defer();
                            var queryString = $location.absUrl().split("?")[1];
                            var params = {};
                            if(queryString) {
                                params = authenticationService.checkForAuthCode(queryString);
                            }
                            if(params['code'] && params['state']) {
                                var redir = function(){
                                    window.location = pageService.appUri;
                                }
                                authenticationService.getNewToken(params['code']).then(function(clientRedirectUri) {
                                    defer.reject({error: 'authcode', redirect: clientRedirectUri});
                                    // if routing fails force it to redirect.
                                    $timeout(redir(), 5000);
                                });
                            } else {
                                defer.resolve();
                            }

                            return defer.promise;
                        }
                    }
                })
                .state('main.auth', {
                    abstract: true,
                    resolve: {
                        // NOTE: for staff-side only, ensures mhpuser has been fetched in router instead of in localResourceDirectoryService
                        authentication: function ($q, pageService, authenticationService, mhpuser) {
                            var defer = $q.defer();
                            authenticationService.checkAuthStatus().then(function(isAuthenticated) {
                                if(isAuthenticated) {
                                    // NOTE: non-400 will get caught by httpInterceptor,
                                    // navigating to state main.unauthorized
                                    $q.all({user: mhpuser.fetch()}).then(
                                        function(responses) {
                                            defer.resolve();
                                        }
                                    );
                                } else {
                                    defer.reject({error: 'auth'});
                                }
                            });
                            return defer.promise;
                        }
                    }
                })
                .state('main.auth.two-panel', {
                    abstract: true,
                    resolve : {
                        previousState: function ($state) {
                            var currentStateData = {
                                isFirstAppRoute: $state.current.name === ""
                            };
                            return currentStateData;
                        }
                    },
                    views: {
                        '@main': {
                            templateUrl: 'src/container/components/content/two-column_template.html',
                            controller: 'TwoPanelController'
                        }
                    }
                })
                .state('main.auth.two-panel.secondary-navigation', {
                    abstract: true,
                    views : {
                        'secondary@main.auth.two-panel' : {
                            templateUrl: "src/container/components/content/secondary-navigation/secondary-navigation_template.html",
                            controller: "SecondaryNavigationController"
                        }
                    }
                })
                .state('main.auth.one-panel', {
                    abstract: true,
                    resolve : {
                        previousState: function ($state) {
                            var currentStateData = {
                                isFirstAppRoute: $state.current.name === ""
                            };
                            return currentStateData;
                        }
                    },
                    views: {
                        '@main': {
                            templateUrl: 'src/container/components/content/single-column_template.html',
                            controller: 'TwoPanelController'
                        }
                    }
                })
                .state('main.splash', {
                    url: '/login',
                    data : {
                        requiresAuth: false
                    },
                    templateUrl: 'src/container/splash/splash_template.html',
                    controller: 'SplashController',
                    module: 'preventNavigation'
                })
                .state('main.auth.sud', {
                    url: '/sud',
                    views: {
                        '@main': {
                            templateUrl: 'src/core/staff-user-disclaimer/sud_template.html',
                            controller: 'SudController'
                        }
                    }
                })

                .state('nonStateRedirect', {
                    url: '/redirecting'
                });


			unsavedWarningsConfigProvider.useTranslateService = false;
		});

		app.run(function ($rootScope, $state, $window, $log, resourceDirectory, pageService, connectionErrorService, sudService, EventBusService) {
			connectionErrorService.run();
			resourceDirectory.fetch();

			$rootScope.$on('$stateChangeError', function (event, toState, toParams, fromState, options, error) {
				if (error.redirect) {
					$state.go('nonStateRedirect');
					$window.open(error.redirect, '_self', null, true);
				} else {
					switch (error.error) {
						case 'auth':
							$state.go('main.splash');
							break;
                    }

                    EventBusService.trigger('stateChangeError', error.error);
				}
			});

			$rootScope.$on('$stateChangeSuccess', function(event, toState, toParams, fromState, options) {
				if (toState.name !== 'main.splash' && sudService.isReadyToServe() && !(!_.isEmpty(toState) && toState.name === 'main.auth.sud')) {
					if (sessionStorage.staffUserDisclaimerAccepted !== 'true' || !sessionStorage.staffUserDisclaimerAccepted) {
						sudService.getDisclaimerStatus().then(function (status) {
							var staffUserDisclaimerAccepted = !_.isEmpty(status) && status.staffUserDisclaimerAccepted;
							if (staffUserDisclaimerAccepted) {
								if (!_.isEmpty(status.staffUserDisclaimerDate)) {
									var staffUserDisclaimerDate = Date.parse(status.staffUserDisclaimerDate);
									sudService.getContent().then(function (data) {
										if (!_.isEmpty(data) && !_.isEmpty(data.date)) {
											var latestSudUpdateDate = Date.parse(data.date);
											if (latestSudUpdateDate > staffUserDisclaimerDate) {
												redirectToState(event, toState, toParams, 'main.auth.sud');
											} else {
												sessionStorage.staffUserDisclaimerAccepted = true;
											}
										}
									});
								}
							} else {
								redirectToState(event, toState, toParams, 'main.auth.sud');
							}
						}).catch(function (e) {
							$log.error(e);
						});
					}
				}

				if(toState.containerClass) {
					$rootScope.containerClass = toState.containerClass;
				}
			});

			function redirectToState(event, toState, toParams, stateName) {
				if (toState.name !== stateName) {
					event.preventDefault();
					$state.go(stateName, toParams);
				}
			}
		});
	});
